#version 410 core

layout(location = 0) in vec3 vColor;     
layout(location = 1) in vec2 vTexCoord;

layout(location = 0) out vec4 fFragColor;

uniform sampler2D uTexture;
uniform vec3 uColor;      
uniform int useTexture;

uniform float uv_x;
uniform float uv_y;
uniform float nx_frames;
uniform float ny_frames;
uniform float alpha;

void main()
{
    if (useTexture == 1) {
        vec4 texColor = texture(uTexture, vTexCoord);
        fFragColor = vec4(texColor.rgb , alpha * texColor.a);
    }

    else if (useTexture == 2) {
        float x  = 1.0 / nx_frames;
        float y  = 1.0 / ny_frames;
        vec4 texColor = texture(uTexture, vec2(vTexCoord.x * x, vTexCoord.y * y) + vec2(x * uv_x, y * uv_y));
         fFragColor = vec4(texColor.rgb , alpha * texColor.a);
    } 

    else {
        fFragColor = vec4(uColor, alpha);
    }
}