#version 410 core

layout(location = 0) in vec3 vColor;     
layout(location = 1) in vec2 vTexCoord;

layout(location = 0) out vec4 fFragColor;

uniform sampler2D uTexture;
uniform vec3 uColor;      
uniform int useTexture;

uniform float uv_x;
uniform float uv_y;
uniform float nx_frames;
uniform float ny_frames;

//radial crop
uniform vec2 center;
uniform float radial;
uniform float start;

void main()
{   
    // Calculate angle of the current fragment
    vec2 toCenter = vTexCoord - center;
    float angle = atan(toCenter.y, toCenter.x);

    // Convert angle to degrees
    angle = degrees(angle);

    // Adjust angle to start from 0 to 360 degrees
    angle = mod(angle + 360.0, 360.0);

    // Define the start and end angles for the desired range
    float startAngle = start;
    float endAngle;

    // Adjusting for the opposite direction
    startAngle = startAngle - radial; // Adjust based on the direction
    endAngle = startAngle + radial; // Adjust based on the direction

    // Normalize the angles to the range [0, 360]
    startAngle = mod(startAngle + 360.0, 360.0);
    endAngle = mod(endAngle + 360.0, 360.0);

    // Handle cases where the end angle wraps around 360 degrees
    if (endAngle < startAngle) {
        // Discard fragments outside the specified angle range
        if (!(angle >= startAngle || angle <= endAngle)) {
            discard;
        }
    } else {
        // Discard fragments outside the specified angle range
        if (!(angle >= startAngle && angle <= endAngle)) {
            discard;
        }
    }

    if (useTexture == 1) {
        fFragColor = texture(uTexture, vTexCoord);
    }

    else if (useTexture == 2) {
        float x  = 1.0 / nx_frames;
        float y  = 1.0 / ny_frames;
        fFragColor = texture(uTexture, vec2(vTexCoord.x * x, vTexCoord.y * y) + vec2(x * uv_x, y * uv_y));
    } 

    else {
        fFragColor = vec4(uColor, 1.0f);
    }
}