#version 410 core

in vec2 TexCoord;
out vec4 FragColor;

uniform sampler2D texture1; // Assuming you're passing your texture here
uniform float mosaicSizeX;  // Size of each mosaic tile in the X direction
uniform float mosaicSizeY;  // Size of each mosaic tile in the Y direction
uniform float chromaticAberration;  // Amount of chromatic aberration

void main()
{
    // Calculate the mosaic texture coordinates
    vec2 mosaicCoord = vec2(floor(TexCoord.x / mosaicSizeX) * mosaicSizeX,
                            floor(TexCoord.y / mosaicSizeY) * mosaicSizeY);

    // Add chromatic aberration by shifting the texture coordinates
    vec2 redOffset = vec2(chromaticAberration, 0.0);
    vec2 greenOffset = vec2(0.0, 0.0); // No offset for green channel
    vec2 blueOffset = vec2(-chromaticAberration, 0.0);

    vec4 redColor = texture(texture1, mosaicCoord + redOffset);
    vec4 greenColor = texture(texture1, mosaicCoord + greenOffset);
    vec4 blueColor = texture(texture1, mosaicCoord + blueOffset);

    // Combine the color channels with chromatic aberration
    FragColor = vec4(redColor.r, greenColor.g, blueColor.b, 1.0);
}