#version 410 core

layout(location = 0) in vec2 aVertexPosition;
layout(location = 1) in vec3 aVertexColor;
layout(location = 2) in vec2 aTexCoord;

layout(location = 0) out vec3 vColor;
layout(location = 1) out vec2 vTexCoord;

uniform mat3 uModel[200];      // Model transformation matrix
uniform mat3 uProjection; // Projection matrix (modified to mat3)

void main() 
{
    // Combine the model and projection transformations (both mat3)
    vec3 projectedPosition = uProjection * (uModel[gl_InstanceID] * vec3(aVertexPosition, 1.0));

    gl_Position = vec4(projectedPosition.xy, 0.0, 1.0);
    vColor = aVertexColor;
    vTexCoord = aTexCoord;
}
