#version 410 core
out vec4 FragColor;

// Function to generate a random float between 0 and 1 using time as a seed
float rand(float time, vec2 co) {
    return fract(sin(dot(co.xy + time, vec2(12.9898, 78.233))) * 43758.5453);
}

uniform float gridSize;
uniform float currentTime; // Time passed from the CPU
uniform float alpha;

void main() {
    vec2 uv = gl_FragCoord.xy / 1080.f;

    // Calculate the square's grid coordinates
    int x = int(uv.x * gridSize);
    int y = int(uv.y * gridSize);

    // Calculate color for the square using UV coordinates, grid coordinates, and current time
    vec3 color = vec3(rand(currentTime, vec2(x, y)), rand(currentTime, vec2(x + 1, y)), rand(currentTime, vec2(x, y + 1)));

    // Apply color and alpha for the square
    FragColor = vec4(color, alpha);
}