#version 410 core

layout(location = 0) in vec3 vColor;     
layout(location = 1) in vec2 vTexCoord;
layout(location = 0) out vec4 fFragColor;

uniform sampler2D uTexture;
uniform vec3 uColor;      
uniform int useTexture;

uniform float uv_x;
uniform float uv_y;
uniform float nx_frames;
uniform float ny_frames;

uniform vec3 glowColor; 
uniform float outlineWidth = 0.02;

void main()
{
    float texAlpha = 1.0;  // Default alpha value
    vec3 color = uColor;   // Default color value

    if(useTexture == 1) {
        texAlpha = texture(uTexture, vTexCoord).a;
        color = vColor;  // Use vertex color when texture is used
    } 
    else if(useTexture == 2) {
        float x  = 1.0 / nx_frames;
        float y  = 1.0 / ny_frames;
        texAlpha = texture(uTexture, vec2(vTexCoord.x * x, vTexCoord.y * y) + vec2(x * uv_x, y * uv_y)).a;
        color = vColor;  // Use vertex color for animated texture
    }

    fFragColor = vec4(color, texAlpha);

    // Calculate the alpha value of the outline
    float outlineAlpha = clamp((outlineWidth - length(texAlpha - 0.5)) * 50.0, 0.0, 1.0);

    // Adjust the alpha channel based on the outline effect
    float alpha = texAlpha + outlineAlpha;

    // Check the alpha channel to determine the glow and outline
    if (alpha > 0.0) {
        fFragColor.rgb = mix(fFragColor.rgb, glowColor, 1);
    }
}